#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Quasicrystal zoomMod01.fsh   by  sheepmaster  
//https://www.shadertoy.com/view/......
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Number of plane waves
const int K = 5;

// Number of stripes per wave
const int NUM_STRIPES = 3;

const int NUM_FREQUENCIES = 8;

// The main (central) spatial frequency
const float MEAN_FREQUENCY = 4.;

// The spread of the spatial frequency envelope
const float SIGMA = 1.;

const float PERIOD = 3.;

const float PI = 4.0 * atan(1.0);

const float mean = MEAN_FREQUENCY * log(2.);

float gaussian(float x) {
    x -= mean;
    return exp(-x * x / 2.) / SIGMA;
}

// Adjust the  wavelengths for the current spatial scale
float wavelength(int i, float sc) {
    return pow(2., float(i)) * sc;
}

// Modulate each wavelength by a Gaussian envelope in log
// frequency, centered around aforementioned mean with defined
// standard deviation
float weight(int i, float sc) {
    return gaussian(log(wavelength(i, sc)));
}

// 7-th order smoothstep function:
// https://en.wikipedia.org/wiki/Smoothstep
// https://gist.github.com/kylemcdonald/77f916240756a8cfebef
float superSmooth(float x) {
	float xSquared = x * x;
	return xSquared * xSquared * (x * (x * (x * -20. + 70.) - 84.) + 35.);
}

//void mainImage(out vec4 fragColor, in vec2 fragCoord) {
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

	float scale = pow(0.5, fract(iTime / PERIOD));

    float weightSum = 0.;
    for (int l = 0; l < NUM_FREQUENCIES; l++) {
        weightSum += weight(l, scale);
    }
    
    // Cartesian coordinates
	vec2 coords = (fragCoord.xy - iResolution.xy / 2.) / iResolution.x
        * 2. * PI * float(NUM_STRIPES);

    float c = 0.;  // Accumulator
    
    // Iterate over all k plane waves
    for (int t = 0; t < K; t++) {
    	float tScaled = float(t) / float(K) * PI;
        vec2 omega = vec2(cos(tScaled), sin(tScaled));

        // Compute the phase of the plane wave
        float ph = dot(coords, omega);

        // Take a weighted sum over the different spatial scales
        for (int l = 0; l < NUM_FREQUENCIES; l++) {
			c += cos(ph * wavelength(l, scale)) * weight(l, scale);
        }
    }
    // Convert the summed waves to a [0,1] interval
    // and then convert to color
    float cScaled = superSmooth((c / (weightSum * float(K)) + 1.) / 2.);
	vec3 color = cScaled * vec3(1.0, 0.0, 1.0);

	fragColor = vec4(color, 1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

